#pragma once

#include "animation.h"

#include <memory>

/**
 * AnimationComposition is multi-device animation bounded in time period.
 *
 * the parts (one part per physical device)
 *
 */
class AnimationComposition {
public:
    AnimationComposition(std::vector<std::shared_ptr<Animation>> animationCompositionList, bool looped);
    virtual ~AnimationComposition() = default;

    bool isLooped() const;
    void restartComposition();

    /**
     * @return animations of this composition, one per device
     *
     * Currently length of this composition in time is determined by length of first of these animation
     */
    virtual std::vector<std::shared_ptr<Animation>> getAnimations();

private:
    /**
     * parts of animation, played on different devices
     */
    const std::vector<std::shared_ptr<Animation>> animationImagesSources_;
    bool looped_ = false;
};
