#pragma once

#include "animation_composition.h"
#include "finishing_type.h"
#include "led_devices.h"
#include "substitution_type.h"

#include <chrono>
#include <memory>
#include <string>

class AnimationConductor {
public:
    using TimePoint = std::chrono::time_point<std::chrono::steady_clock, std::chrono::nanoseconds>;
    using OnFinishedListener = std::function<void()>;
    using OnChangedListener = std::function<void()>;

    AnimationConductor(std::vector<const std::shared_ptr<AnimationComposition>> compositions,
                       SubstitutionType substitutionType = SubstitutionType::BACKGROUND_DEFAULT,
                       FinishingType finishingType = FinishingType::FIRST,
                       std::string name = " <Animation Sequence> ");

    virtual ~AnimationConductor() = default;

    const std::shared_ptr<AnimationComposition>& nextComposition();

    virtual bool isFinished() const;

    bool updateTime(TimePoint timePoint);

    void resetConductor();

    [[nodiscard]] virtual std::string getName() const;

    std::shared_ptr<AnimationComposition> getCurrentComposition() const;

    SubstitutionType getSubstitutionType();

    void setOnFinishedListener(OnFinishedListener onFinishedListener);
    void setOnChangedListener(OnChangedListener onChangedListener);

protected:
    SubstitutionType substitutionType_;
    FinishingType finishingType_;
    std::vector<const std::shared_ptr<AnimationComposition>> animationCompositionList_;
    OnChangedListener onChangedListener_;

private:
    OnFinishedListener onFinishedListener_;
    std::vector<const std::shared_ptr<AnimationComposition>>::iterator currentAnimationComposition_;
    std::string name_;
};
