#include "animation_substitution.h"

AnimationSubstitution::AnimationSubstitution(std::shared_ptr<AnimationConductor> mainAnimation)
    : mainAnimation_(std::move(mainAnimation))
{
}

bool AnimationSubstitution::updateTime(TimePoint timePoint) {
    if (mainAnimation_) {
        mainAnimation_->updateTime(timePoint);
    }
    if (priorityAnimation_) {
        priorityAnimation_->updateTime(timePoint);
    }
    return false;
}

bool AnimationSubstitution::isFinished() const {
    if (mainAnimation_ && !mainAnimation_->isFinished()) {
        return false;
    }

    if (priorityAnimation_ && !priorityAnimation_->isFinished()) {
        return false;
    }

    return true;
}

std::vector<const std::shared_ptr<AnimationComposition>> AnimationSubstitution::currentCompositions() const {
    std::vector<const std::shared_ptr<AnimationComposition>> compositions;
    if (priorityAnimation_ && !priorityAnimation_->isFinished()) {
        compositions.emplace_back(priorityAnimation_->getCurrentComposition());
    }
    if (mainAnimation_ && !mainAnimation_->isFinished()) {
        compositions.emplace_back(mainAnimation_->getCurrentComposition());
    }
    return compositions;
}

void AnimationSubstitution::setMainAnimation(std::shared_ptr<AnimationConductor> mainAnimation) {
    mainAnimation_ = std::move(mainAnimation);
}

void AnimationSubstitution::setPriorityAnimation(std::shared_ptr<AnimationConductor> priorityAnimation) {
    priorityAnimation_ = std::move(priorityAnimation);
}
