#pragma once

#include "animation_composition.h"
#include "animation_conductor.h"
#include "led_devices.h"

#include <chrono>
#include <memory>
#include <string>

/**
 * Layered composition with two simultaneous animations
 *
 * One with priority has visible Animation over other
 **/
class AnimationSubstitution final {
public:
    AnimationSubstitution() = default;
    explicit AnimationSubstitution(std::shared_ptr<AnimationConductor> mainAnimation);

    using TimePoint = std::chrono::time_point<std::chrono::steady_clock, std::chrono::nanoseconds>;

    std::vector<const std::shared_ptr<AnimationComposition>> currentCompositions() const;

    bool isFinished() const;

    bool updateTime(TimePoint timePoint);

    void setMainAnimation(std::shared_ptr<AnimationConductor> mainAnimation);

    void setPriorityAnimation(std::shared_ptr<AnimationConductor> priorityAnimation);

private:
    /**
     * Default animation.
     * Main animation that in general may have all components.
     */
    std::shared_ptr<AnimationConductor> mainAnimation_;

    /**
     * Animation "with substitution". It has priority component(s).
     * It "substitutes" that component(s) in default, main animation.
     */
    std::shared_ptr<AnimationConductor> priorityAnimation_;
};
