#pragma once

#include "animation.h"

class ClockAnimationBase: public Animation {
public:
    ClockAnimationBase(std::weak_ptr<quasar::LedDevice> ledDevice, int64_t utcOffsetSeconds = 0);

    bool finished() const override;

    TimePoint getEndOfFrameTimePoint() const override;

    std::string getName() const override;

    void resetAnimation() override;
    void updateTime(TimePoint timePoint) override;
    void startAnimationFrom(TimePoint timePoint) override;
    std::chrono::nanoseconds getLength() const override;

    bool started() const;

private:
    bool updateTimeStr();

protected:
    std::chrono::milliseconds frameLength_ = std::chrono::milliseconds(1000);
    std::string timeStr_;

private:
    const int64_t utcOffsetSeconds_;

    std::chrono::time_point<std::chrono::steady_clock> endOfFrame_;
    bool started_ = false;
};
