#include "default_animation_conductor.h"

#include "default_animation_composition.h"

DefaultAnimationConductor::DefaultAnimationConductor(std::shared_ptr<AnimationComposition> animationComposition,
                                                     SubstitutionType substitutionType)
    : DefaultAnimationConductor(std::vector<const std::shared_ptr<AnimationComposition>>{std::move(animationComposition)}, substitutionType)
{
}

DefaultAnimationConductor::DefaultAnimationConductor(std::shared_ptr<Animation> animation, SubstitutionType substitutionType)
    : DefaultAnimationConductor(
          std::vector<const std::shared_ptr<AnimationComposition>>{std::make_unique<DefaultAnimationComposition>(std::move(animation))},
          substitutionType)
{
}

DefaultAnimationConductor::DefaultAnimationConductor(std::vector<const std::shared_ptr<AnimationComposition>> compositions,
                                                     SubstitutionType substitutionType, FinishingType finishingType, std::string name)
    : AnimationConductor(std::move(compositions), substitutionType, finishingType, std::move(name))
{
}

void DefaultAnimationConductor::setSubstitutionType(SubstitutionType substitutionType) {
    substitutionType_ = substitutionType;
}
