#pragma once

#include "animation_conductor.h"

#include <yandex_io/modules/leds/led_patterns/led_pattern.h>

class DefaultAnimationConductor: public AnimationConductor {
public:
    DefaultAnimationConductor(std::shared_ptr<Animation> animation, SubstitutionType substitutionType = SubstitutionType::BACKGROUND_DEFAULT);

    explicit DefaultAnimationConductor(std::shared_ptr<AnimationComposition> animationComposition,
                                       SubstitutionType substitutionType = SubstitutionType::BACKGROUND_DEFAULT);

    DefaultAnimationConductor(std::vector<const std::shared_ptr<AnimationComposition>> compositions,
                              SubstitutionType substitutionType = SubstitutionType::BACKGROUND_DEFAULT,
                              FinishingType finishingType = FinishingType::FIRST,
                              std::string name = " <Animation Sequence> ");
    ~DefaultAnimationConductor() override = default;

    void setSubstitutionType(SubstitutionType substitutionType);
};
