#include "default_led_devices.h"

#include <utility>

using namespace quasar;

DefaultLedDevices::DefaultLedDevices(std::shared_ptr<LedController> ledController)
    : ledController_(std::move(ledController))
    , devicesList_{ledController_}
{
}

const std::vector<std::shared_ptr<quasar::LedDevice>>& DefaultLedDevices::getDevicesList() const {
    return devicesList_;
}

std::shared_ptr<LedController> DefaultLedDevices::getDefaultDevice() const {
    return ledController_;
}
