#pragma once
#include "led_devices.h"

#include <yandex_io/modules/leds/led_controller/led_controller.h>

#include <vector>

/**
 * Single led device wrapper
 */
class DefaultLedDevices: public LedDevices {
public:
    explicit DefaultLedDevices(std::shared_ptr<quasar::LedController> ledController);

    const std::vector<std::shared_ptr<quasar::LedDevice>>& getDevicesList() const override;
    std::shared_ptr<quasar::LedController> getDefaultDevice() const override;

private:
    std::shared_ptr<quasar::LedController> ledController_;
    std::vector<std::shared_ptr<quasar::LedDevice>> devicesList_;
};
