#include "idle_animation_conductor.h"

#include "idle_animation_composition.h"

#include <memory>

IdleAnimationConductor::IdleAnimationConductor(
    std::shared_ptr<Animation> idleAnimation,
    const quasar::LedManager& ledManager)
    : AnimationConductor({std::make_shared<IdleAnimationComposition>(std::move(idleAnimation), ledManager)})
{
}

std::string IdleAnimationConductor::getName() const {
    return " <IdleAnimationConductor> ";
}
