#pragma once

#include <yandex_io/modules/leds/led_controller/led_controller.h>

/*
 * Led screen and head leds
 * "Head leds" is default device
 */
class LedDevices {
public:
    virtual ~LedDevices() = default;

    virtual const std::vector<std::shared_ptr<quasar::LedDevice>>& getDevicesList() const = 0;

    /**
     * Default device is often small colored composition of leds
     */
    virtual std::shared_ptr<quasar::LedController> getDefaultDevice() const = 0;
};
