#include "stoppable_animation_conductor.h"

#include "default_animation_composition.h"

#include <utility>

StoppableAnimationConductor::StoppableAnimationConductor(std::shared_ptr<Animation> ledPattern, SubstitutionType substitutionType)
    : DefaultAnimationConductor(std::move(ledPattern), substitutionType)
{
}

void StoppableAnimationConductor::stop() {
    finished_ = true;
    if (onChangedListener_) {
        onChangedListener_();
    }
}

bool StoppableAnimationConductor::isFinished() const {
    return finished_ || DefaultAnimationConductor::isFinished();
}
