#pragma once

#include "animation_conductor.h"
#include "default_animation_conductor.h"

#include <yandex_io/modules/leds/led_patterns/led_pattern.h>

#include <mutex>

class StoppableAnimationConductor: public DefaultAnimationConductor {
public:
    explicit StoppableAnimationConductor(std::shared_ptr<Animation> pattern, SubstitutionType substitutionType = SubstitutionType::BACKGROUND_DEFAULT);

    ~StoppableAnimationConductor() override = default;

    void stop();
    bool isFinished() const override;

private:
    std::atomic<bool> finished_ = false;
};
