#pragma once

#include "animation.h"

class TimerCountdownAnimationBase: public Animation {
public:
    TimerCountdownAnimationBase(std::weak_ptr<quasar::LedDevice> ledDevice, std::chrono::system_clock::time_point timerEnd);

    TimePoint getEndOfFrameTimePoint() const override;
    std::string getName() const override;

    void resetAnimation() override;
    void updateTime(TimePoint timePoint) override;
    void startAnimationFrom(TimePoint timePoint) override;
    std::chrono::nanoseconds getLength() const override;

    bool started() const;
    bool finished() const override;

private:
    void updateTimeStr();

protected:
    std::chrono::milliseconds frameLength_ = std::chrono::milliseconds(250);
    std::string timeStr_;

private:
    const std::chrono::system_clock::time_point timerEnd_;

    std::chrono::time_point<std::chrono::steady_clock> endOfFrame_;
    bool started_ = false;
    bool finished_ = false;
};
