#pragma once

#include "led_pattern.h"
#include "listening_pattern.h"
#include "progress_pattern.h"
#include "volume_pattern.h"

#include <yandex_io/modules/leds/led_controller/led_controller.h>

#include <map>
#include <memory>
#include <string>

namespace quasar {

    class LedPatternStorage {
    public:
        LedPatternStorage(const std::string& path, std::shared_ptr<quasar::LedController> controller);

        std::shared_ptr<LedPattern> getPattern(const std::string& name) const;
        std::shared_ptr<ListeningPattern> getListeningPattern(double doaAngle) const;
        std::shared_ptr<VolumePattern> getVolumePattern(double volume, bool looped = false) const;
        std::shared_ptr<ProgressPattern> getProgressPattern() const;
        std::shared_ptr<LedPattern> getIdlePattern() const;

    protected:
        const std::shared_ptr<quasar::LedController>& getController() const;

    private:
        std::map<std::string, std::shared_ptr<LedPattern>> patterns_;
        const std::shared_ptr<quasar::LedController> controller_;
    };

} // namespace quasar
