#pragma once

#include "led_pattern.h"

#include <atomic>
#include <memory>

namespace quasar {

    class ListeningPattern: public LedPattern {
    public:
        ListeningPattern(std::shared_ptr<LedPattern> base, double doaAngle, bool invertRotation = false);

        bool finished() const override;
        void resetAnimation() override;
        LedFrame getCurrentFrame() const override;

        virtual void setDoaAngle(double doaAngle);
        virtual double getDoaAngle() const;
        void startAnimationFrom(TimePoint startTime) override;
        void updateTime(TimePoint timePoint) override;

        void finish();

    private:
        std::atomic<double> doaAngle_;
        mutable double currentRotationAngle_;
        const bool invertRotation_;
        std::atomic<bool> finished_;
        mutable TimePoint lastRotationUpdate_;
        TimePoint animationUpdate_;
    };

} // namespace quasar
