#include "progress_pattern.h"

#include <yandex_io/libs/logging/logging.h>

#include <cmath>

using namespace quasar;

ProgressPattern::ProgressPattern(std::shared_ptr<quasar::LedPattern> base)
    : LedPattern(*base)

{
    progress_.store(0);
}

LedFrame ProgressPattern::getCurrentFrame() const {
    double progress = progress_.load();

    int count = round(ledCount_ * progress);

    if (count < 1) {
        count = 1;
    }
    if (count > ledCount_) {
        count = ledCount_;
    }

    LedFrame firstFrame = frames[0];
    std::fill(firstFrame.circle.begin() + count, firstFrame.circle.end(), rgbw_color());

    LedFrame frame = LedPattern::getCurrentFrame();
    LedFrame result = getRotatedFrame(firstFrame, frame.rotation, ledCount_);
    result.delayMs = frame.delayMs;

    return result;
}

void ProgressPattern::setProgress(double progressPercents)
{
    progress_.store(progressPercents / 100.0);
}
