#include "volume_pattern.h"

#include <cmath>

using namespace quasar;

VolumePattern::VolumePattern(std::shared_ptr<LedPattern> basePattern,
                             double volume,
                             bool looped)
    : LedPattern(basePattern->getLedCount(), "volume_" + std::to_string(int(volume * 10)) + ".led", basePattern->getDevice())
{
    if (basePattern->empty())
    {
        throw std::runtime_error("Cannot create volume LED pattern with empty base pattern");
    }

    if (volume < 0) {
        volume = 0;
    }
    if (volume > 1) {
        volume = 1;
    }

    frames.clear();
    std::vector<LedFrame> baseFrames = basePattern->getFrames();

    frames.push_back(baseFrames[round(volume * (baseFrames.size() - 1))]);
    frames[0].delayMs = 500;
    if (looped) {
        loopFromIndex = 0;
        isBackground_ = true;
    } else {
        setSmooth(50);
        addSmoothFrame(getIdleFrame(500, ledCount_));
    }
}
