#include <yandex_io/modules/leds/led_controller/color_readers.h>
#include <yandex_io/modules/leds/led_manager/led_animator.h>
#include <yandex_io/modules/leds/led_manager/ng/default_animation_conductor.h>
#include <yandex_io/modules/leds/led_patterns/led_pattern.h>
#include <yandex_io/modules/leds/led_patterns/volume_pattern.h>

#include <yandex_io/libs/terminate_waiter/terminate_waiter.h>

#include <iostream>

using namespace quasar;

int led_util(int argc, char** argv, std::unique_ptr<LedDevices> ledDevices)
{
    TerminateWaiter waiter;

    LedAnimator animator(LedPattern::getIdlePattern(ledDevices->getDefaultDevice()->getLedCount(), ledDevices->getDefaultDevice()));

    LedCircle frame(size_t(ledDevices->getDefaultDevice()->getLedCount()));

    auto pattern = LedPattern::loadFromFile(argv[1], ledDevices->getDefaultDevice());

    if (argc >= 3 && std::string(argv[2]) == "--dump-raw")
    {
        std::cout << pattern->getInRawFormat();

        return 0;
    }
    if (argc >= 3 && std::string(argv[2]) == "--volume")
    {
        for (float i = 0; i < 10; i += 1) {
            auto volume = std::make_shared<VolumePattern>(pattern, i / 10, false);
            animator.play(std::make_shared<DefaultAnimationConductor>(volume, SubstitutionType::FOREGROUND));
            std::this_thread::sleep_for(std::chrono::milliseconds(50));
        }

        return 0;
    }

    animator.play(std::make_shared<DefaultAnimationConductor>(pattern, SubstitutionType::FOREGROUND));

    waiter.wait();
    return 0;
}
