#include "media_error_renderer.h"

#include <yandex_io/modules/leds/led_manager/ng/default_animation_conductor.h>
#include <yandex_io/modules/leds/led_patterns/progress_pattern.h>

using namespace quasar;

MediaErrorRenderer::MediaErrorRenderer(std::shared_ptr<quasar::LedManager> ledManager)
    : ledManager_(std::move(ledManager))
{
}

void MediaErrorRenderer::onMediaError(ContentType /*contentType*/)
{
    /* Play Error animation once */
    auto pattern = ledManager_->getPattern("error.led");
    pattern->setDuration(3000);
    ledManager_->play(std::make_shared<DefaultAnimationConductor>(std::move(pattern), SubstitutionType::FOREGROUND));
}
