#pragma once

#include <yandex_io/modules/leds/led_manager/led_manager.h>

#include <yandex_io/sdk/media_observer.h>

#include <memory>

class MediaErrorRenderer final: public YandexIO::MediaObserver {
public:
    explicit MediaErrorRenderer(std::shared_ptr<quasar::LedManager> ledManager);
    ~MediaErrorRenderer() = default;

    /**
     * @brief Callback will draw "error.led" animation
     */
    void onMediaError(ContentType contentType) override;

    void onMediaRequest(ContentType /* contentType */) override {
    }
    void onMediaStarted(ContentType /* contentType */) override {
    }
    void onMediaPaused(ContentType /* contentType */) override {
    }
    void onMediaResumed(ContentType /* contentType */) override {
    }
    void onMediaSwitchedForward(ContentType /* contentType */) override {
    }
    void onMediaSwitchedBackward(ContentType /* contentType */) override {
    }
    void onMediaLiked(ContentType /* contentType */) override {
    }
    void onMediaDisliked(ContentType /* contentType */) override {
    }

private:
    std::shared_ptr<quasar::LedManager> ledManager_;
};
