#include "aux_metrics_sender.h"

namespace YandexIO {

    AuxMetricsSender::AuxMetricsSender(std::shared_ptr<YandexIO::ITelemetry> telemetry, std::chrono::seconds heartbeatPeriod)
        : heartbeatPeriod_(heartbeatPeriod)
        , telemetry_(std::move(telemetry))
    {
    }

    AuxMetricsSender::~AuxMetricsSender() {
        heartbeatPeriodic_.reset();
    }

    void AuxMetricsSender::auxEnabled() {
        telemetry_->reportEvent("auxEnabled");
        heartbeatPeriodic_ = std::make_unique<quasar::PeriodicExecutor>([this]() {
            telemetry_->reportEvent("progressHeartbeatAux");
        }, heartbeatPeriod_, quasar::PeriodicExecutor::PeriodicType::SLEEP_FIRST);
    }

    void AuxMetricsSender::auxDisabled() {
        heartbeatPeriodic_.reset();
        telemetry_->reportEvent("auxDisabled");
    }

} /* namespace YandexIO */
