#pragma once

#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/libs/threading/periodic_executor.h>

#include <chrono>
#include <memory>

namespace YandexIO {

    class AuxMetricsSender final {
    public:
        AuxMetricsSender(std::shared_ptr<YandexIO::ITelemetry> telemetry, std::chrono::seconds heartbeatPeriod);
        ~AuxMetricsSender();

        void auxEnabled();
        void auxDisabled();

    private:
        std::unique_ptr<quasar::PeriodicExecutor> heartbeatPeriodic_;
        const std::chrono::seconds heartbeatPeriod_;
        const std::shared_ptr<YandexIO::ITelemetry> telemetry_;
    };

} /* namespace YandexIO */
