#include "dev_input_aux_detector.h"

#include <yandex_io/libs/logging/logging.h>

namespace {

    std::vector<std::string> makeNodeVector(std::string node) {
        return {std::move(node)};
    }

    std::map<uint16_t, int> makeButtonMap(uint16_t code) {
        return {{code, 1}};
    }

    std::vector<YandexIO::DevInputButtons::ButtonInfo> makeReadBeforePolling(std::string node, uint16_t code) {
        return {{node, code, EV_SW}};
    }

} // namespace

namespace YandexIO {

    DevInputAuxDetector::DevInputAuxDetector(std::shared_ptr<YandexIO::ITelemetry> telemetry, const std::string& node, uint16_t code)
        : sender_(std::move(telemetry), std::chrono::seconds(30))
        , auxPoller_(makeNodeVector(node), makeButtonMap(code), makeReadBeforePolling(node, code))
    {
        auxPoller_.setSendButtonEventCallback(std::bind(&DevInputAuxDetector::handleAuxEvent, this, std::placeholders::_2));
        auxPoller_.start();
    }

    DevInputAuxDetector::~DevInputAuxDetector() {
        auxPoller_.stop();
    }

    void DevInputAuxDetector::handleAuxEvent(Buttons::ButtonEvent event) {
        switch (event) {
            case Buttons::ButtonEvent::PRESS_START: {
                YIO_LOG_INFO("Aux enabled");
                sender_.auxEnabled();
                break;
            }
            case Buttons::ButtonEvent::PRESS_RELEASE: {
                YIO_LOG_INFO("Aux disabled");
                sender_.auxDisabled();
                break;
            }
            case Buttons::ButtonEvent::LONG_PRESS: {
                break;
            }
        }
    }

} /* namespace YandexIO */
