#pragma once

#include <yandex_io/modules/metrics/auxiliary/aux_metrics_sender.h>

#include <yandex_io/modules/buttons/dev_input/dev_input_buttons.h>

#include <memory>

namespace YandexIO {

    class DevInputAuxDetector {
    public:
        /**
         * @brief Detector for aux state: Detect state and send metrics (with heartbeats each 30 seconds);
         * @param[in] telemetry - telemetry implementation used to send metrics
         * @param[in] devInputNode - path to /dev/input/event* node that will be polled
         * @param[in] code - key code for AUX event (provided by /dev/input/event*)
         * @note: DevInputAuxDetector expect that code has type EV_SW. Otherwise it can be skipped (by DevInputButtons)
         */
        DevInputAuxDetector(std::shared_ptr<YandexIO::ITelemetry> telemetry, const std::string& devInputNode, uint16_t code);
        ~DevInputAuxDetector();

    private:
        void handleAuxEvent(Buttons::ButtonEvent event);
        AuxMetricsSender sender_;
        DevInputButtons auxPoller_;
    };

} /* namespace YandexIO */
