#pragma once

#include <yandex_io/libs/telemetry/telemetry.h>
#include <yandex_io/sdk/sdk_state_observer.h>

#include <memory>
#include <mutex>
#include <optional>
#include <string>

namespace YandexIO {

    class PowerOnMetricaSender: public YandexIO::SDKStateObserver {
    public:
        PowerOnMetricaSender(std::shared_ptr<ITelemetry> telemetry, std::string guardFile, const std::string& monotonicTimeFile);

        void onSDKState(const YandexIO::SDKState& state) override;

    private:
        const std::optional<int> powerOffTs_;
        const std::string guardFile_;
        const std::shared_ptr<YandexIO::ITelemetry> telemetry_;
        bool sentOncePerBoot_;
    };

} /* namespace YandexIO */
