#pragma once

#include "bio_capability.h"
#include "sound_setup/bio_sound_setup.h"

#include <yandex_io/interfaces/auth/connector/auth_provider.h>

#include <yandex_io/libs/device/device.h>

#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <yandex_io/sdk/audio_source/i_audio_source_client.h>
#include <yandex_io/sdk/private/endpoint_storage/endpoint.h>

#include <memory>

namespace YandexIO {

    class BioCapabilitySwitcher
        : public BackendConfigObserver {
    public:
        BioCapabilitySwitcher(
            std::shared_ptr<SDKInterface> sdk,
            std::shared_ptr<IDevice> device,
            std::shared_ptr<BioSoundSetup::IListener> soundSetupListener,
            std::shared_ptr<IEndpoint> localEndpoint,
            std::shared_ptr<quasar::IAuthProvider> authProvider,
            std::shared_ptr<IAudioSourceClient> audioSourceClient);

    private:
        // BackendConfigObserver
        void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;

    private:
        const std::shared_ptr<SDKInterface> sdk_;
        const std::shared_ptr<IDevice> device_;
        const std::shared_ptr<IEndpoint> localEndpoint_;
        const std::shared_ptr<quasar::IAuthProvider> authProvider_;
        const std::shared_ptr<IAudioSourceClient> audioSourceClient_;
        const std::shared_ptr<BioSoundSetup::IListener> soundSetupListener_;

        const BioConfig bioConfig_;
        std::shared_ptr<BioCapability> bioCapability_;
        bool enabled_ = false;
    };

} // namespace YandexIO
