#include "enrollment_engine_safety_wrapper.h"

#include <yandex_io/libs/logging/logging.h>

YIO_DEFINE_LOG_MODULE("BioCapability");

using namespace YandexIO;

void EnrollmentEngineSafetyWrapper::SetEnrollments(const TEnrollments& enrollments) {
    try {
        return holder_->SetEnrollments(enrollments);
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("SetEnrollments: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "SetEnrollments: Unknown exception");
    }
}

THashMap<EnrollmentEngineSafetyWrapper::TEnrollmentID, TString> EnrollmentEngineSafetyWrapper::GetEnrollmentsVersionInfo() const {
    try {
        return holder_->GetEnrollmentsVersionInfo();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("GetEnrollmentsVersionInfo: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "GetEnrollmentsVersionInfo: Unknown exception");
    }
    return {};
}

void EnrollmentEngineSafetyWrapper::StartRequest() {
    try {
        return holder_->StartRequest();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("StartRequest: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "StartRequest: Unknown exception");
    }
}

bool EnrollmentEngineSafetyWrapper::IsRequestActive() const {
    try {
        return holder_->IsRequestActive();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("IsRequestActive: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "IsRequestActive: Unknown exception");
    }
    return false;
}

void EnrollmentEngineSafetyWrapper::AddChunk(TConstArrayRef<unsigned char> audio, bool lastChunk) {
    try {
        return holder_->AddChunk(audio, lastChunk);
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("AddChunk: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "AddChunk: Unknown exception");
    }
}

void EnrollmentEngineSafetyWrapper::SetRequestExternalVoiceprint(TBlob blob) {
    try {
        return holder_->SetRequestExternalVoiceprint(std::move(blob));
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("SetRequestExternalVoiceprint: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "SetRequestExternalVoiceprint: Unknown exception");
    }
}

NJson::TJsonValue EnrollmentEngineSafetyWrapper::FinishRequest() {
    try {
        return holder_->FinishRequest();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("FinishRequest: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "FinishRequest: Unknown exception");
    }
    return {};
}

void EnrollmentEngineSafetyWrapper::StartEnrollment() {
    try {
        return holder_->StartEnrollment();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("StartEnrollment: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "StartEnrollment: Unknown exception");
    }
}

TBlob EnrollmentEngineSafetyWrapper::CommitEnrollment() {
    try {
        return holder_->CommitEnrollment();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("CommitEnrollment: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "CommitEnrollment: Unknown exception");
    }
    return {};
}

void EnrollmentEngineSafetyWrapper::CancelEnrollment() {
    try {
        return holder_->CancelEnrollment();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("CancelEnrollment: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "CancelEnrollment: Unknown exception");
    }
}

bool EnrollmentEngineSafetyWrapper::IsEnrollmentActive() const {
    try {
        return holder_->IsEnrollmentActive();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("IsEnrollmentActive: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "IsEnrollmentActive: Unknown exception");
    }
    return false;
}

TMaybe<EnrollmentEngineSafetyWrapper::TEnrollmentID> EnrollmentEngineSafetyWrapper::GetMatchedEnrollmentID() const {
    try {
        return holder_->GetMatchedEnrollmentID();
    } catch (std::exception& ex) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", std::string("GetMatchedEnrollmentID: ") + ex.what());
    } catch (...) {
        YIO_LOG_ERROR_EVENT("BioCapability.EnrollmentEngineException", "GetMatchedEnrollmentID: Unknown exception");
    }
    return {};
}
