#pragma once

#include <voicetech/bio/ondevice/lib/engine/enrollment_engine.h>

namespace YandexIO {

    class EnrollmentEngineSafetyWrapper: public NBio::NDevice::IEnrollmentEngine {
    public:
        explicit EnrollmentEngineSafetyWrapper(TFsPath modelDirPath)
            : holder_{NBio::NDevice::IEnrollmentEngine::Load(modelDirPath)}
        {
        }

        void SetEnrollments(const TEnrollments& enrollments) override;
        THashMap<TEnrollmentID, TString> GetEnrollmentsVersionInfo() const override;

        void StartRequest() override;
        bool IsRequestActive() const override;
        void AddChunk(TConstArrayRef<unsigned char> audio, bool lastChunk) override;
        void SetRequestExternalVoiceprint(TBlob blob) override;
        NJson::TJsonValue FinishRequest() override;

        void StartEnrollment() override;
        TBlob CommitEnrollment() override;
        void CancelEnrollment() override;
        bool IsEnrollmentActive() const override;

        TMaybe<TEnrollmentID> GetMatchedEnrollmentID() const override;

    private:
        THolder<IEnrollmentEngine> holder_;
    };

} // namespace YandexIO
