#pragma once

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/setup_parser/sound_data_receiver.h>

#include <yandex_io/modules/voice_assistant_blocker/voice_assistant_blocker.h>

#include <yandex_io/sdk/audio_source/i_audio_source_client.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <atomic>
#include <memory>
#include <vector>

namespace YandexIO {

    class BioSoundSetup {
    public:
        class IListener {
        public:
            ~IListener() = default;

            virtual void onBioSoundParsingStart(std::chrono::seconds timeout) = 0;
            virtual void onBioSoundParsingSuccess(const std::string& code) = 0;
            virtual void onBioSoundParsingStop() = 0;
            virtual void onBioSoundTransferStart() = 0;
            virtual void onBioSoundSetupError() = 0;
        };

    public:
        BioSoundSetup(
            std::shared_ptr<YandexIO::IDevice> device,
            std::shared_ptr<SDKInterface> sdk,
            std::shared_ptr<IAudioSourceClient> audioClient);

        void addListener(std::weak_ptr<IListener> listener);

        void startParsing(std::chrono::seconds timeout);
        void stopParsing();

    private:
        void onDataReceived(const std::vector<unsigned char>& payload, int protocolVersion);
        void onUnsupportedProtocol(int version);
        void onTransferStart();
        void onTransferError();

        using OnAudioData = std::function<void(const ChannelsData&)>;
        OnAudioData getOnAudioDataCallback();

    private:
        VoiceAssistantBlocker voiceAssistantBlocker_;

        using WeakIListener = std::weak_ptr<IListener>;
        std::set<WeakIListener, std::owner_less<WeakIListener>> listeners_;

        const std::weak_ptr<IFilePlayerCapability> filePlayerCapability_;

        const std::shared_ptr<IAudioSourceClient> audioClient_;
        const std::shared_ptr<IAudioSourceClient::Listener> audioListener_;

        quasar::SoundDataReceiver soundDataReceiver_;
        std::atomic<bool> isActive_{false};
    };

} // namespace YandexIO
