#include "sound_power_off_controller.h"

#include <yandex_io/modules/sync_file_player_wrapper/sync_file_player_wrapper.h>

SoundPowerOffController::SoundPowerOffController(std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability)
    : filePlayerCapability_(std::move(filePlayerCapability))
{
}

void SoundPowerOffController::powerOffWithSound(const std::string& fileName,
                                                std::optional<quasar::proto::AudioChannel> channel,
                                                std::chrono::milliseconds timeout)
{
    syncPlaySoundFile(filePlayerCapability_, fileName, channel, timeout);
    powerOff();
}

void SoundPowerOffController::rebootWithSound(const std::string& fileName,
                                              std::optional<quasar::proto::AudioChannel> channel,
                                              std::chrono::milliseconds timeout)
{
    syncPlaySoundFile(filePlayerCapability_, fileName, channel, timeout);
    /* this to avoid clash with reboot from linux/reboot.h */
    this->reboot();
}
