#pragma once

#include "power_off_controller.h"

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>

#include <chrono>
#include <memory>
#include <string>

class SoundPowerOffController: public PowerOffController {
public:
    explicit SoundPowerOffController(std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability);
    virtual ~SoundPowerOffController() = default;

    /**
     * @brief Play sound and then power off (using PowerOffController::powerOff)
     * @brief timeout - timeout to play sound. If didn't finish in this timeout -> power off anyway
     */
    void powerOffWithSound(const std::string& fileName,
                           std::optional<quasar::proto::AudioChannel> channel,
                           std::chrono::milliseconds timeout);
    /**
     * @brief Play sound and then reboot device (using PowerOffController::reboot)
     * @brief timeout - timeout to play sound. If didn't finish in this timeout -> power off anyway
     */
    void rebootWithSound(const std::string& fileName,
                         std::optional<quasar::proto::AudioChannel> channel,
                         std::chrono::milliseconds timeout);

private:
    std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability_;
};
