#pragma once

#include <yandex_io/capabilities/file_player/interfaces/i_file_player_capability.h>

#include <yandex_io/modules/bluetooth/bluetooth_controller/bluetooth_controller.h>
#include <yandex_io/modules/leds/led_manager/led_manager.h>
#include <yandex_io/modules/version_provider/version_provider.h>

#include <yandex_io/libs/sweep_tone_generator/sweep_tone_generator.h>
#include <yandex_io/sdk/sound_command_observer.h>

#include <list>
#include <memory>
#include <mutex>
#include <optional>
#include <string>

class QCModeHandler: public YandexIO::SoundCommandObserver {
public:
    QCModeHandler(std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability,
                  std::shared_ptr<quasar::LedManager> ledManager,
                  std::shared_ptr<YandexIO::BluetoothController> bluetoothController,
                  std::shared_ptr<YandexIO::VersionProvider> versionProvider,
                  std::optional<std::string> buttonsTestSound = std::nullopt);

    QCModeHandler(std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability,
                  std::shared_ptr<quasar::LedManager> ledManager,
                  std::shared_ptr<YandexIO::BluetoothController> bluetoothController,
                  std::shared_ptr<YandexIO::VersionProvider> versionProvider,
                  std::shared_ptr<AnimationComposition> qcAnimationComposition,
                  std::optional<std::string> buttonsTestSound);

    ~QCModeHandler() = default;

    enum class QCMode {
        LEDS_TEST,
        BUTTONS_TEST,
        SWEEP_TONE,
        BLUETOOTH,
        PROVIDE_VERSION
    };

    class Listener {
    public:
        virtual ~Listener() = default;

        virtual void onQCModeStarted(QCMode mode) = 0;
        virtual void onQCModeStopped(QCMode mode) = 0;
    };
    void addListener(std::shared_ptr<Listener> listener);

    void startQCMode(QCMode mode);
    void stopQCMode(QCMode mode);

private:
    void onCommand(std::string_view /*command*/) override;

    std::mutex mutex_;

    std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability_;
    std::shared_ptr<quasar::LedManager> ledManager_;
    std::shared_ptr<YandexIO::BluetoothController> bluetoothController_;
    std::shared_ptr<YandexIO::VersionProvider> versionProvider_;

    std::shared_ptr<AnimationComposition> qcAnimationComposition_;

    const std::string SWEEP_TONE_PATH = "/tmp/sweep_tone.wav";
    const std::optional<std::string> buttonsTestSound_;

    std::list<std::shared_ptr<Listener>> listeners_;
};
