#include "quasar_device_state_holder.h"

void QuasarDeviceStateHolder::onSDKState(const YandexIO::SDKState& deviceState)
{
    std::scoped_lock guard(mutex_);
    deviceState_.sdkState = deviceState;
    if (deviceState_.sdkState.updateState.state == YandexIO::SDKState::UpdateState::State::DOWNLOADING) {
        hasStartedDownloading_ = true;
    }
}

void QuasarDeviceStateHolder::onBtConnected(bool connected) {
    std::scoped_lock guard(mutex_);
    if (!deviceState_.bluetoothStreamInState.has_value()) {
        deviceState_.bluetoothStreamInState.emplace();
    }
    deviceState_.bluetoothStreamInState->isConnected = connected;
}

void QuasarDeviceStateHolder::onBtPlaying(bool playing) {
    std::scoped_lock guard(mutex_);
    if (!deviceState_.bluetoothStreamInState.has_value()) {
        deviceState_.bluetoothStreamInState.emplace();
    }
    deviceState_.bluetoothStreamInState->isPlaying = playing;
}

bool QuasarDeviceStateHolder::isAlarmPlaying() const {
    std::scoped_lock guard(mutex_);
    return deviceState_.sdkState.isAlarmPlaying || deviceState_.sdkState.isTimerPlaying;
}

bool QuasarDeviceStateHolder::isMediaPlaying() const {
    std::scoped_lock guard(mutex_);
    return deviceState_.isMediaPlaying();
}

bool QuasarDeviceStateHolder::isAliceIdle() const {
    std::scoped_lock guard(mutex_);
    switch (deviceState_.sdkState.aliceState.state) {
        case YandexIO::SDKState::AliceState::State::NONE:
        case YandexIO::SDKState::AliceState::State::IDLE:
            return true;
        default:
            return false;
    }
}

bool QuasarDeviceStateHolder::isDeviceUpdating() const {
    std::scoped_lock guard(mutex_);
    return isDeviceUpdatingUnlocked();
}

bool QuasarDeviceStateHolder::isDeviceUpdatingUnlocked() const {
    return deviceState_.sdkState.updateState.state == YandexIO::SDKState::UpdateState::State::DOWNLOADING || deviceState_.sdkState.updateState.state == YandexIO::SDKState::UpdateState::State::APPLYING;
}

bool QuasarDeviceStateHolder::hasDeviceStartedDownloading() const {
    std::scoped_lock guard(mutex_);
    return hasStartedDownloading_;
}

bool QuasarDeviceStateHolder::isDeviceConfigured() const {
    std::scoped_lock guard(mutex_);
    return isDeviceConfiguredUnlocked();
}

bool QuasarDeviceStateHolder::isDeviceConfiguredUnlocked() const {
    return deviceState_.sdkState.configurationState == YandexIO::SDKState::ConfigurationState::CONFIGURED;
}

bool QuasarDeviceStateHolder::isDeviceReady() const {
    std::scoped_lock guard(mutex_);
    return isDeviceConfiguredUnlocked() && !isDeviceUpdatingUnlocked();
}

bool QuasarDeviceStateHolder::hasCall() const {
    std::scoped_lock guard(mutex_);
    return deviceState_.sdkState.hasIncomingCall() || deviceState_.sdkState.hasCurrentCall();
}

bool QuasarDeviceStateHolder::hasIncomingCall() const {
    std::scoped_lock guard(mutex_);
    return deviceState_.sdkState.hasIncomingCall();
}

bool QuasarDeviceStateHolder::hasCurrentCall() const {
    std::scoped_lock guard(mutex_);
    return deviceState_.sdkState.hasCurrentCall();
}
