#pragma once

#include <yandex_io/modules/bluetooth/bluetooth_state_listener/i_bluetooth_state_listener.h>
#include <yandex_io/modules/device_state/extended_device_state.h>

#include <yandex_io/sdk/sdk_state_observer.h>

#include <mutex>

class QuasarDeviceStateHolder: public YandexIO::SDKStateObserver, public YandexIO::IBluetoothStateListener {
public:
    void onSDKState(const YandexIO::SDKState& deviceState) override;
    void onBtConnected(bool connected) override;
    void onBtPlaying(bool playing) override;

    /**
     * @brief Check if alarm or timer is currently playing
     */
    bool isAlarmPlaying() const;
    /**
     * @brief Check if any kind of media is playing (music, radio or video)
     */
    bool isMediaPlaying() const;
    /**
     * @brief Check if Alice state is idle (Alice wait for WakeUpWord)
     */
    bool isAliceIdle() const;
    /**
     * @brief Check if device is downloading or applying update
     */
    bool isDeviceUpdating() const;

    /**
     * @brief Check if device has started downloading update since last reboot.
     * If download is paused at the moment, this method will still return true.
     */
    bool hasDeviceStartedDownloading() const;

    /**
     * @brief Check if device is in Configured state
     */
    bool isDeviceConfigured() const;

    /**
     * @brief devices is configured and not updating
     */
    bool isDeviceReady() const;

    bool hasCall() const;
    bool hasIncomingCall() const;
    bool hasCurrentCall() const;

private:
    bool isDeviceUpdatingUnlocked() const;
    bool isDeviceConfiguredUnlocked() const;

private:
    mutable std::mutex mutex_;
    YandexIO::ExtendedDeviceState deviceState_;
    bool hasStartedDownloading_;
};
