#pragma once

#include "smart_volume_manager.h"

#include <yandex_io/modules/volume_manager/base/volume_manager.h>

#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <memory>
#include <string>

namespace YandexIO {

    class SmartVolumeConfigurer
        : public BackendConfigObserver {
    public:
        static std::shared_ptr<SmartVolumeConfigurer> create(
            std::shared_ptr<SDKInterface> sdk, std::shared_ptr<VolumeManager> volumeManager, std::shared_ptr<IAudioSourceClient> audioSource);

    private:
        SmartVolumeConfigurer(std::shared_ptr<SDKInterface> sdk, std::shared_ptr<VolumeManager> volumeManager, std::shared_ptr<IAudioSourceClient> audioSource);

        // BackendConfigObserver
        void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
        void onDeviceConfig(const std::string& configName, const std::string& jsonConfigValue) override;

    private:
        const std::shared_ptr<SDKInterface> sdk_;
        const std::shared_ptr<VolumeManager> volumeManager_;
        const std::shared_ptr<IAudioSourceClient> audioSource_;

        std::shared_ptr<SmartVolumeManager> smartVolumeManager_;
        SmartVolumeManager::Config config_;
        bool enabled_ = false;
    };

} // namespace YandexIO
