#pragma once

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability_listener.h>
#include <yandex_io/libs/voice_stats/voice_stats.h>
#include <yandex_io/modules/volume_manager/base/volume_manager.h>
#include <yandex_io/sdk/audio_source/i_audio_source_client.h>

#include <optional>

namespace YandexIO {

    class SmartVolumeManager
        : public IAliceCapabilityListener {
    public:
        struct Config {
            std::map<int, int> rmsVolumeMap;
            bool useVqeChannel = false;
            bool useVoiceFilter = false;

            bool operator==(const Config& rhs) const = default;
        };

        explicit SmartVolumeManager(
            std::shared_ptr<VolumeManager> volumeManager,
            std::shared_ptr<IAudioSourceClient> audioSource,
            Config config);

        void updateConfig(Config config);

    private:
        // IAliceCapabilityListener
        void onAliceStateChanged(quasar::proto::AliceState state) override;
        void onAliceTtsCompleted() override;

        int getVolumeByRms(int rms) const;

    private:
        struct RMSSource: public IAudioSourceClient::Listener {
            explicit RMSSource(const Config& config);

            void onAudioData(const ChannelsData& data) override;
            quasar::RMSInfo getRms() const;

        public:
            std::shared_ptr<quasar::VoiceStats> voiceStats;
            bool useRmsWeights = false;
            const std::vector<float> rmsWeights;
        };

    private:
        std::shared_ptr<VolumeManager> volumeManager_;
        std::shared_ptr<RMSSource> rmsSource_;
        Config config_;
        bool restoreVolumeMode_ = false;
    };

} // namespace YandexIO
