#include "spotter_channels.h"

#include <yandex_io/libs/logging/logging.h>

#include <voicetech/spotter/embedded/libdecode/spotter.h>

#include <util/generic/scope.h>
#include <util/system/yassert.h>

using namespace YandexIO;

namespace {

    AudioInputChannelType convertChannelType(channel_type channelType) {
        switch (channelType) {
            case CHANNEL_OMNI:
                return AUDIO_INPUT_CHANNEL_TYPE_VQE_OMNI;
            case CHANNEL_BEAMFORMING:
                return AUDIO_INPUT_CHANNEL_TYPE_VQE_BEAMFORMING;
            case CHANNEL_FEEDBACK:
                return AUDIO_INPUT_CHANNEL_TYPE_RAW_FEEDBACK_SYNC;
            case CHANNEL_BNR:
                return AUDIO_INPUT_CHANNEL_TYPE_VQE_BACKGROUND_NOISE_REDUCER;
            case CHANNEL_RAW_MIC_BEST:
                return AUDIO_INPUT_CHANNEL_TYPE_RAW_MAIN_MIC_SYNC;
            case CHANNEL_RAW_MIC_OTHER:
                return AUDIO_INPUT_CHANNEL_TYPE_RAW_AUXILIARY_MIC_SYNC;
            case CHANNEL_TYPE_ENUM_SIZE:
                Y_FAIL("unreachable enum value");
        }
    }

} // namespace

std::map<AudioInputChannelType, uint8_t> YandexIO::getRequiredChannelsFromSpotterPath(const std::string& path) {
    if (path.empty()) {
        return {};
    }

    int** spotterCounts = new int*(nullptr);
    Y_DEFER {
        if (*spotterCounts != nullptr) {
            std::free(*spotterCounts);
        }
        delete spotterCounts;
    };

    spotter_required_channel_count_from_dirname(const_cast<char*>(path.c_str()), spotterCounts);
    if (*spotterCounts == nullptr) {
        return {};
    }
    std::vector<int> counts{*spotterCounts, *spotterCounts + CHANNEL_TYPE_ENUM_SIZE};

    std::map<AudioInputChannelType, uint8_t> result;
    for (size_t i = 0; i < counts.size(); ++i) {
        if (counts[i] <= 0) {
            continue;
        }
        result.emplace(convertChannelType(static_cast<channel_type>(i)), static_cast<uint8_t>(counts[i]));
    }
    return result;
}
