#pragma once

#include "spotter_downloader.h"

#include <yandex_io/capabilities/spotter/interfaces/i_spotter_capability.h>
#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/threading/i_callback_queue.h>
#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <json/json.h>

#include <memory>

namespace YandexIO {

    class SpotterConfigurer
        : public BackendConfigObserver,
          public ISpotterCapability::IListener,
          public std::enable_shared_from_this<SpotterConfigurer> {
    public:
        static std::shared_ptr<SpotterConfigurer> install(
            std::unique_ptr<quasar::ICallbackQueue> callbackQueue,
            SDKInterface& sdk,
            std::shared_ptr<IDevice> device);
        ~SpotterConfigurer();

        // from BackendConfigObserver
        void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
        void onAccountConfig(const std::string& configName, const std::string& jsonConfigValue) override;

        // from ISpotterCapability::IListener
        void onModelError(std::shared_ptr<ISpotterCapability> capability, const std::set<std::string>& spotterTypes) override;
        void onModelSet(std::shared_ptr<ISpotterCapability> capability, const std::set<std::string>& spotterTypes) override;

        // for testing
        SpotterDownloader& getSpotterDownloader();

    private:
        SpotterConfigurer(
            std::unique_ptr<quasar::ICallbackQueue> callbackQueue,
            SDKInterface& sdk,
            std::shared_ptr<IDevice> device);
        void init(SDKInterface& sdk);

        void processSpotterConfig(const Json::Value& jsonConfig);
        void processEnableSpottersConfig(const Json::Value& jsonConfig);
        void processSpotterModelUpdate(const std::string& spotterType);
        void updateSpotterDownloaderState();
        void provideSpotterWord();

        std::map<std::string, std::string> getActivationModels() const;
        std::map<std::string, std::string> getCommandModels() const;
        std::map<std::string, std::string> getNaviOldModels() const;

        void updateSpotters();
        void updateActivationSpotters(std::map<std::string, std::string> typeToModels);
        void updateCommandSpotters(std::map<std::string, std::string> typeToModels);
        void updateNaviOldSpotters(std::map<std::string, std::string> typeToModels);

    private:
        std::unique_ptr<quasar::ICallbackQueue> callbackQueue_;
        std::shared_ptr<IDevice> device_;
        SpotterDownloader spotterDownloader_;
        bool defaultEnableSpotters_;
        bool enableSpotters_;
        Json::Value spotterConfig_;
        std::string spotterWord_;
        std::shared_ptr<ISpotterCapability> activationSpotter_;
        std::shared_ptr<ISpotterCapability> commandSpotter_;
        std::shared_ptr<ISpotterCapability> naviOldSpotter_;

        std::map<std::string, std::string> activationModels_;
        std::map<std::string, std::string> commandModels_;
        std::map<std::string, std::string> naviOldModels_;
    };

} // namespace YandexIO
