#include "spotter_validator.h"

#include <yandex_io/libs/base/crc32.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <algorithm>

YIO_DEFINE_LOG_MODULE("spotter_validator");

using namespace YandexIO;

bool SpotterValidator::isValid(const std::string& spotterPath, uint32_t expectedChecksum) {
    auto fileList = quasar::getDirectoryFileListRecursive(spotterPath);
    std::sort(fileList.begin(), fileList.end());
    quasar::Crc32 crc;
    try {
        for (auto& file : fileList) {
            crc.processFile(file);
        }
    } catch (const std::exception& ex) {
        YIO_LOG_ERROR_EVENT("SpotterValidate.FailedCrc32Compute", "Failed to validate custom spotter: " << ex.what());
        return false;
    }

    const auto actualChecksum = crc.checksum();
    YIO_LOG_DEBUG("Actual checksum = " << actualChecksum << ", Expected checksum = " << expectedChecksum);

    return actualChecksum == expectedChecksum;
}
