#include "default_on_configure_done_greeting_observer.h"

#include <yandex_io/libs/logging/logging.h>

#include <iostream>
#include <utility>

DefaultOnConfigureDoneGreetingObserver::DefaultOnConfigureDoneGreetingObserver(
    std::shared_ptr<YandexIO::SDKInterface> sdk,
    DeviceModeObserver::ConfigurationSuccessState configurationSuccessState,
    std::string soundName)
    : sdk_(std::move(sdk))
    , configurationSuccessState_(configurationSuccessState)
    , soundName_(std::move(soundName))
    , demoModeListener_(std::make_shared<DemoModeStatusListener>())
{
}

void DefaultOnConfigureDoneGreetingObserver::subscribeToSDK() {
    sdk_->addDeviceModeObserver(shared_from_this());
}

void DefaultOnConfigureDoneGreetingObserver::onConfigureSuccessUpdate(DeviceModeObserver::ConfigurationSuccessState configurationSuccessState) {
    if (demoModeListener_->isInDemoMode()) {
        YIO_LOG_INFO("Demo mode is active. Ignore");
        return;
    }
    YIO_LOG_INFO("onConfigureSuccessUpdate");
    std::lock_guard<std::mutex> lockGuard(mutex_);
    if (configurationSuccessState_ == configurationSuccessState) {
        sdk_->getFilePlayerCapability()->playSoundFile(soundName_, quasar::proto::AudioChannel::DIALOG_CHANNEL);
    }
}

std::weak_ptr<IDemoModeListener> DefaultOnConfigureDoneGreetingObserver::getDemoModeListener() {
    return demoModeListener_;
}
