#pragma once

#include <yandex_io/modules/demo_mode/demo_mode_status_listener/demo_mode_status_listener.h>

#include <yandex_io/sdk/device_mode_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <atomic>
#include <optional>

class DefaultOnConfigureDoneGreetingObserver: public std::enable_shared_from_this<DefaultOnConfigureDoneGreetingObserver>,
                                              public YandexIO::DeviceModeObserver {
public:
    DefaultOnConfigureDoneGreetingObserver(
        std::shared_ptr<YandexIO::SDKInterface> sdk,
        DeviceModeObserver::ConfigurationSuccessState configurationSuccessState,
        std::string soundName);
    ~DefaultOnConfigureDoneGreetingObserver() = default;

    void onConfigureSuccessUpdate(DeviceModeObserver::ConfigurationSuccessState configurationSuccessState) override;

    void onStartSetup(bool /*isFirstSetup*/) override {
    }
    void onSoundDataTransferStart() override {
    }
    void onConnectingToNetwork() override {
    }
    void onSetupError() override {
    }
    void onFinishSetup() override {
    }

    void subscribeToSDK();

    std::weak_ptr<IDemoModeListener> getDemoModeListener();

private:
    const std::shared_ptr<YandexIO::SDKInterface> sdk_;
    const DeviceModeObserver::ConfigurationSuccessState configurationSuccessState_;
    const std::string soundName_;
    std::mutex mutex_;
    const std::shared_ptr<DemoModeStatusListener> demoModeListener_;
    std::atomic<bool> isMuted_{false};
};
