#pragma once

#include "default_on_configure_done_greeting_observer.h"

#include <yandex_io/modules/demo_mode/demo_mode_status_listener/demo_mode_status_listener.h>

#include <yandex_io/libs/base/directives.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/threading/lifetime.h>
#include <yandex_io/sdk/backend_config_observer.h>
#include <yandex_io/sdk/device_mode_observer.h>
#include <yandex_io/sdk/directive_observer.h>
#include <yandex_io/sdk/sdk_interface.h>

#include <atomic>
#include <memory>
#include <optional>

class RemoteOnConfigureDoneGreetingObserver: public std::enable_shared_from_this<RemoteOnConfigureDoneGreetingObserver>,
                                             public YandexIO::DeviceModeObserver,
                                             public YandexIO::BackendConfigObserver,
                                             public YandexIO::DirectiveObserver {
public:
    struct Settings {
        bool enabled = false;
        std::chrono::milliseconds waitResponseDirectiveTimeout{3000};
        std::chrono::milliseconds allServicesConnectingTimeout{3000};
    };

    RemoteOnConfigureDoneGreetingObserver(
        std::shared_ptr<YandexIO::SDKInterface> sdk,
        DeviceModeObserver::ConfigurationSuccessState configurationSuccessState,
        std::string soundName,
        const Settings& settings = Settings{false, std::chrono::milliseconds{3000}, std::chrono::milliseconds{3000}});
    ~RemoteOnConfigureDoneGreetingObserver();

    void onDirective(const std::string& name, const std::string& /*vinsRequestId*/, const std::string& /*jsonPayload*/) override;
    void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
    void onConfigureSuccessUpdate(DeviceModeObserver::ConfigurationSuccessState configurationSuccessState) override;
    void onStartSetup(bool /*isFirstSetup*/) override{};

    void onSoundDataTransferStart() override {
    }
    void onConnectingToNetwork() override {
    }
    void onSetupError() override {
    }
    void onFinishSetup() override {
    }
    constexpr static const char* CONFIG_NAME = "starting_configure_settings";

public:
    virtual void requestAction();
    void onFallBack();
    void requestSemanticFrame();
    void subscribeToSDK();
    void subscribeToSystemConfig();

    std::weak_ptr<IDemoModeListener> getDemoModeListener();

protected:
    const std::shared_ptr<YandexIO::SDKInterface> sdk_;
    quasar::NamedCallbackQueue asyncQueue_{"RemoteOnConfigureDoneGreetingObserver"};
    std::atomic<bool> isDirectiveWait_{false};
    std::chrono::milliseconds waitResponseDirectiveTimeout_{3000};

private:
    const DeviceModeObserver::ConfigurationSuccessState configurationSuccessState_;
    std::chrono::milliseconds allServicesConnectingTimeout_{3000};
    bool startingConfigureEnabled_ = false;
    bool configReceived_ = false;
    const std::string soundName_;
    quasar::Lifetime lifetime_;
    const std::shared_ptr<DemoModeStatusListener> demoModeListener_;
    std::atomic<bool> isMuted_{false};
};
