#include "success_greeting_observer.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

SuccessGreetingObserver::SuccessGreetingObserver(
    std::shared_ptr<YandexIO::SDKInterface> sdk,
    DeviceModeObserver::ConfigurationSuccessState configurationSuccessState,
    std::string soundName,
    const RemoteOnConfigureDoneGreetingObserver::Settings& settings)
    : RemoteOnConfigureDoneGreetingObserver(std::move(sdk), configurationSuccessState, std::move(soundName), settings)
{
}

// call under mutex
void SuccessGreetingObserver::requestAction()
{
    YIO_LOG_INFO("requestAction");
    isDirectiveWait_ = true;

    auto request = std::make_shared<YandexIO::VinsRequest>(
        buildStartingOnboardingSuccessSemanticFrame(),
        YandexIO::VinsRequest::createSoftwareDirectiveEventSource());
    request->setEnqueued(true);

    sdk_->getAliceCapability()->startRequest(std::move(request), nullptr);
}

void SuccessGreetingObserver::onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) {
    RemoteOnConfigureDoneGreetingObserver::onSystemConfig(configName, jsonConfigValue);
    if (configName != CONFIG_NAME) {
        return;
    }

    asyncQueue_.add([this, jsonConfigValue] {
        const Json::Value startingConfigureSettings = quasar::parseJson(jsonConfigValue);
        if (startingConfigureSettings.isMember("wait_onboarding_starting_success_update_directive_timeout_ms")) {
            const int waitOnboardingStartingSuccessDirectiveTimeout = startingConfigureSettings["wait_onboarding_starting_success_update_directive_timeout_ms"].asInt();
            waitResponseDirectiveTimeout_ = std::chrono::milliseconds(waitOnboardingStartingSuccessDirectiveTimeout);
            YIO_LOG_INFO("wait_onboarding_starting_success_update_directive_timeout_ms: " << waitOnboardingStartingSuccessDirectiveTimeout);
        }
    });
}

Json::Value SuccessGreetingObserver::buildStartingOnboardingSuccessSemanticFrame() {
    Json::Value semanticFrame;
    Json::Value semanticFramePayload;

    semanticFramePayload["typed_semantic_frame"]["onboarding_starting_configure_success"] = Json::objectValue;

    auto& analytics = semanticFramePayload["analytics"];
    analytics["origin"] = "SmartSpeaker";
    analytics["purpose"] = "get_starting_configure_success_onboarding";

    semanticFrame["name"] = "@@mm_semantic_frame";
    semanticFrame["type"] = "server_action";
    semanticFrame["payload"] = semanticFramePayload;

    return semanticFrame;
}
