#pragma once

#include "remote_on_configure_done_greeting_observer.h"

class SuccessGreetingObserver: public RemoteOnConfigureDoneGreetingObserver {
public:
    SuccessGreetingObserver(
        std::shared_ptr<YandexIO::SDKInterface> sdk,
        DeviceModeObserver::ConfigurationSuccessState configurationSuccessState,
        std::string soundName,
        const RemoteOnConfigureDoneGreetingObserver::Settings& settings = Settings{});
    ~SuccessGreetingObserver() = default;

    void requestAction() override;
    void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;

private:
    static Json::Value buildStartingOnboardingSuccessSemanticFrame();
};
