#pragma once

#include "remote_on_configure_done_greeting_observer.h"

class UpdateGreetingObserver: public RemoteOnConfigureDoneGreetingObserver {
public:
    UpdateGreetingObserver(
        std::shared_ptr<YandexIO::SDKInterface> sdk,
        DeviceModeObserver::ConfigurationSuccessState configurationSuccessState,
        std::string soundName,
        const RemoteOnConfigureDoneGreetingObserver::Settings& settings = Settings{});
    ~UpdateGreetingObserver() = default;

    void onStartSetup(bool isFirstSetup) override;
    void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue) override;
    void requestAction() override;

private:
    static Json::Value buildStartingOnboardingUpdateSemanticFrame(bool isFirstSetup);

private:
    bool isFirstSetup_ = false;
};
