#include "sync_file_player_wrapper.h"

#include <yandex_io/capabilities/file_player/play_sound_file_listener.h>
#include <yandex_io/libs/logging/logging.h>

#include <future>

bool syncPlaySoundFile(std::shared_ptr<YandexIO::IFilePlayerCapability> filePlayerCapability,
                       std::string fileName,
                       std::optional<quasar::proto::AudioChannel> channel,
                       const std::chrono::milliseconds& timeout,
                       std::function<void()> onStarted) {
    YIO_LOG_INFO("Sync playSoundFile " << fileName);
    auto promise = std::make_shared<std::promise<void>>();
    auto future = promise->get_future();
    auto listener = std::make_shared<YandexIO::PlaySoundFileListener>(onStarted, [promise{std::move(promise)}]() {
        promise->set_value();
    });

    filePlayerCapability->playSoundFile(fileName, channel, std::nullopt, std::move(listener));

    if (future.wait_for(timeout) == std::future_status::timeout) {
        YIO_LOG_WARN("Sync playSoundFile " << fileName << " timeout");
        return false;
    }
    YIO_LOG_INFO("Sync playSoundFile " << fileName << " completed");
    return true;
}
