#pragma once

#include <yandex_io/interfaces/auth/i_auth_provider.h>
#include <yandex_io/libs/base/named_callback_queue.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/delay_timings_policy/delay_timings_policy.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/json_utils/json_utils.h>

#include <atomic>
#include <mutex>
#include <optional>
#include <string_view>

namespace YandexIO {
    class VersionProvider {
    public:
        struct Settings {
            std::string cachedVersionFileName;
            std::string versionSendGuardFile;
            std::chrono::milliseconds versionSendBaseSleepFor;
            std::chrono::milliseconds versionSendMaxSleepFor;
            std::string deviceID;
            std::string backendUrl;
            std::string platform;
            std::string softwareVersion;
        };

        VersionProvider(std::shared_ptr<quasar::IAuthProvider> authProvider, std::shared_ptr<IDevice> device, std::string version, Settings settings);
        ~VersionProvider();

    public:
        void provideVersion();

    private:
        bool sendVersion();
        bool sendRequestToBackend();
        void saveState(const Json::Value& version);
        std::optional<Json::Value> readCachedState();

    private:
        const std::shared_ptr<quasar::IAuthProvider> authProvider_;
        const std::shared_ptr<IDevice> device_;
        const std::string version_;
        const Settings settings_;

        quasar::BackoffRetriesWithRandomPolicy delayTimingsPolicy_;

        std::atomic<bool> giveUp_{false};
        quasar::NamedCallbackQueue callbackQueue_{"VersionProvider"};
    };

} // namespace YandexIO
