#include "voice_assistant_blocker.h"

#include <yandex_io/libs/logging/logging.h>

using namespace YandexIO;

VoiceAssistantBlocker::VoiceAssistantBlocker(std::shared_ptr<SDKInterface> sdk, std::string module, std::optional<std::string> errorSound)
    : sdk_(std::move(sdk))
    , module_(std::move(module))
    , errorSound_(std::move(errorSound))
{
    // need unblock to handle crashes
    sdk_->unblockVoiceAssistant(module_);
}

void VoiceAssistantBlocker::block() {
    YIO_LOG_INFO("Alice blocked by source: " << module_ << ", error sound: " << errorSound_.value_or("<null>"));
    sdk_->blockVoiceAssistant(module_, errorSound_);
}

void VoiceAssistantBlocker::unblock() {
    YIO_LOG_INFO("Alice unblocked by source: " << module_);
    sdk_->unblockVoiceAssistant(module_);
}
