#include "xiva_push_alice_requester.h"

#include <yandex_io/capabilities/alice/interfaces/vins_request.h>

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/logging/logging.h>

#include <util/system/yassert.h>

YIO_DEFINE_LOG_MODULE("xiva_alice_requester");

using namespace YandexIO;

std::shared_ptr<XivaPushAliceRequester> XivaPushAliceRequester::install(YandexIO::SDKInterface& sdk) {
    auto xivaAliceRequester = std::shared_ptr<XivaPushAliceRequester>(new XivaPushAliceRequester(sdk.getAliceCapability()));
    sdk.addPushNotificationObserver(xivaAliceRequester);
    return xivaAliceRequester;
}

XivaPushAliceRequester::XivaPushAliceRequester(std::shared_ptr<IAliceCapability> aliceCapability)
    : aliceCapability_(std::move(aliceCapability))
{
    Y_VERIFY(aliceCapability_);
}

void XivaPushAliceRequester::onPushNotification(const std::string& operation, const std::string& message) {
    // todo: use XivaOperations instead of plain strings

    try {
        std::shared_ptr<VinsRequest> request;

        if ("server_action" == operation) {
            auto event = quasar::parseJson(message);
            request = std::make_shared<VinsRequest>(std::move(event), VinsRequest::createSoftwareDirectiveEventSource());
        } else if ("reminder" == operation) {
            auto event = VinsRequest::buildReminderEvent(message);
            request = std::make_shared<VinsRequest>(std::move(event), VinsRequest::createSoftwareDirectiveEventSource());
            request->setIsReminder(true);
        } else if ("text_action" == operation) {
            auto event = VinsRequest::buildTextActionEvent(message);
            request = std::make_shared<VinsRequest>(std::move(event), VinsRequest::createSoftwareDirectiveEventSource());
        }

        if (request != nullptr) {
            request->setEnqueued(true);
            aliceCapability_->startRequest(std::move(request), nullptr);
        }
    } catch (const std::exception& e) {
        YIO_LOG_ERROR_EVENT("XivaPushAliceRequester.FailedHandlePush", "Failed to handlePush: " << e.what());
    }
}
